/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.domain.mesh.bean;

import com.tp_link.eap.domain.mesh.bean.MeshFailoverStatus$Status;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.CollectionUtils;

public class MeshFailoverStatus {
    private static ConcurrentHashMap<String, MeshFailoverStatus$Status> statusMap = new ConcurrentHashMap();

    public static boolean isIdle(String apMac) {
        return statusMap.get(apMac) == MeshFailoverStatus$Status.IDLE;
    }

    public static boolean isDoing(String apMac) {
        return statusMap.get(apMac) == MeshFailoverStatus$Status.DOING;
    }

    public static void putDoingAps(List<String> apMacs) {
        if (!CollectionUtils.isEmpty(apMacs)) {
            for (String string : apMacs) {
                statusMap.put(string, MeshFailoverStatus$Status.DOING);
            }
        }
    }

    public static void refreshIDLE(String apMac) {
        statusMap.put(apMac, MeshFailoverStatus$Status.IDLE);
    }

    public static void refreshDoing(String apMac) {
        statusMap.put(apMac, MeshFailoverStatus$Status.DOING);
    }

    public static void refreshStatus(String apMac, int status) {
        statusMap.put(apMac, MeshFailoverStatus$Status.values()[status]);
    }

    public static int getStatus(String apMac) {
        if (statusMap.contains(apMac)) {
            return statusMap.get(apMac).ordinal();
        }
        return MeshFailoverStatus$Status.IDLE.ordinal();
    }
}

